** SPF: UNEMP
**
noi shell wget -N -v --cache=off -nd "http://www.philadelphiafed.org/research-and-data/real-time-center/survey-of-professional-forecasters/data-files/files/Individual_UNEMP.xls"
noi shell st convert_spf.stcmd
use spf-unemp.dta, replace
gen int qdate = yq(year,quarter)
tsset id qdate, q
drop if qdate==.
order id qdate
drop unempa unempb unempc unempd
forvalues i=1/6 {
  rename UNEMP`i' unemp`i'
  qui replace unemp`i'=. if unemp`i'==-999
}
drop quarter industry year
reshape long unemp, i(id qdate) j(horiz)
collapse (mean) unemp_mean = unemp (median) unemp_med = unemp, by(qdate horiz)
rename unemp_mean ru_avg
rename unemp_med ru_med
** the date lags the data by 1 quarter because the forecast target is GDP
** this shift (-2) sets it so that horizon 0 is the current quarter for RU
replace horiz=horiz-2
drop if horiz<0
reshape wide ru_avg ru_med, i(qdate) j(horiz)
aorder
compress
tsset qdate, q
save spf-unemp.dta, replace

gen year = year(dofq(qdate))
gen qtr = quarter(dofq(qdate))
keep year qtr *med*
forvalues h=0/4 {
  rename ru_med`h' f_lur_`h'
}
outsheet year qtr f_* using lur-spf.csv, comma replace

if "$S_OS"=="Unix" exit, STATA clear
